using System;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        string[] xs = Console.ReadLine().Split(' ');
        string[] hs = Console.ReadLine().Split(' ');

        long[] x = new long[n];
        long[] h = new long[n];
        for (int i = 0; i < n; i++)
        {
            x[i] = long.Parse(xs[i]);
            h[i] = long.Parse(hs[i]);
        }

        // rucno sortiranje po x (selection sort)
        int[] idx = new int[n];
        for (int i = 0; i < n; i++) idx[i] = i;
        for (int i = 0; i < n - 1; i++)
        {
            int min = i;
            for (int j = i + 1; j < n; j++)
            {
                if (x[idx[j]] < x[idx[min]]) min = j;
            }
            int tmp = idx[i];
            idx[i] = idx[min];
            idx[min] = tmp;
        }

        long[] X = new long[n];
        long[] H = new long[n];
        int[] orig = new int[n];
        for (int k = 0; k < n; k++)
        {
            X[k] = x[idx[k]];
            H[k] = h[idx[k]];
            orig[k] = idx[k];
        }

        long[] result = new long[n];
        for (int k = 0; k < n; k++)
        {
            long best = long.MaxValue;
            long xi = X[k], hi = H[k];

            // proveri sve jarbole
            for (int j = 0; j < n; j++)
            {
                if (j == k) continue;
                if (H[j] >= hi)
                {
                    long d = Math.Abs(X[j] - xi);
                    if (d < best) best = d;
                }
            }

            // konopac levo
            if (k > 0)
            {
                long a = H[k - 1] + X[k - 1];
                long b = H[k] + X[k];
                double xv = (a - H[k] + X[k]) / 2.0;
                long yv = H[k] - (long)Math.Round(X[k] - xv);

                if (hi >= yv && hi <= H[k - 1])
                {
                    long candX = H[k - 1] + X[k - 1] - hi;
                    if (candX >= X[k - 1] && candX <= (long)xv)
                        best = Math.Min(best, Math.Abs(xi - candX));
                }
            }

            // konopac desno
            if (k < n - 1)
            {
                double xv = (H[k] + X[k] - H[k + 1] + X[k + 1]) / 2.0;
                long yv = H[k + 1] - (long)Math.Round(X[k + 1] - xv);

                if (hi >= yv && hi <= H[k + 1])
                {
                    long candX = hi + (X[k + 1] - H[k + 1]);
                    if (candX <= X[k + 1] && candX >= (long)xv)
                        best = Math.Min(best, Math.Abs(candX - xi));
                }
            }

            if (best == long.MaxValue)
                result[orig[k]] = -1;
            else
                result[orig[k]] = best;
        }

        for (int i = 0; i < n; i++)
            Console.WriteLine(result[i]);
    }
}